/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.registry.forge;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.components.DummyOriginComponent;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.network.PacketDistributor;

public class ModComponentsArchitecturyImpl {
    public static final ResourceLocation SYNC_PACKET_OTHER = Origins.identifier("forge/sync_origin_other");
    @CapabilityInject(value=OriginComponent.class)
    public static Capability<OriginComponent> ORIGIN_COMPONENT_CAPABILITY;

    public static OriginComponent getOriginComponent(Entity player) {
        if (player instanceof PlayerEntity) {
            return (OriginComponent)player.getCapability(ORIGIN_COMPONENT_CAPABILITY).orElseGet(DummyOriginComponent::getInstance);
        }
        return DummyOriginComponent.getInstance();
    }

    public static void syncOriginComponent(Entity player) {
        if (!(player.func_130014_f_().func_72863_F() instanceof ServerChunkProvider)) {
            return;
        }
        IPacket<?> packet = ModComponentsArchitecturyImpl.buildOtherPacket(player);
        if (packet != null) {
            PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player).send(packet);
        }
    }

    public static IPacket<?> buildOtherPacket(Entity entity) {
        Optional<OriginComponent> originComponent = ModComponentsArchitecturyImpl.maybeGetOriginComponent(entity);
        if (originComponent.isPresent()) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            CompoundNBT tag = new CompoundNBT();
            originComponent.get().writeToNbt(tag);
            buffer.func_150787_b(entity.func_145782_y());
            buffer.func_150786_a(tag);
            return NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SYNC_PACKET_OTHER, (PacketBuffer)buffer);
        }
        return null;
    }

    public static void syncWith(ServerPlayerEntity player, Entity provider) {
        IPacket<?> packet = ModComponentsArchitecturyImpl.buildOtherPacket(provider);
        if (packet != null) {
            PacketDistributor.PLAYER.with(() -> player).send(packet);
        }
    }

    public static Optional<OriginComponent> maybeGetOriginComponent(Entity player) {
        if (player instanceof PlayerEntity) {
            return player.getCapability(ORIGIN_COMPONENT_CAPABILITY).resolve();
        }
        return Optional.empty();
    }

    public static class OriginStorage
    implements Capability.IStorage<OriginComponent> {
        public INBT writeNBT(Capability<OriginComponent> capability, OriginComponent object, Direction arg) {
            CompoundNBT tag = new CompoundNBT();
            object.writeToNbt(tag);
            return tag;
        }

        public void readNBT(Capability<OriginComponent> capability, OriginComponent object, Direction arg, INBT arg2) {
            object.readFromNbt((CompoundNBT)arg2);
        }
    }
}

